<?php

namespace App\Http\Resources;

use App\Http\Resources\ParentResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
  /**
   * Transform the resource into an array.
   *
   * @param  \Illuminate\Http\Request  $request
   * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
   */
  public function toArray($request)
  {
    return [
      "id" => $this->id,
      "parent" => new ParentResource($this->chlidren),
      "name" => $this->name,
      "status" => $this->status,
    ];
  }
}
