

<?php $__env->startSection('title', 'Bootstrap Tables'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Basic Tables start -->
    <div class="row" id="basic-table">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-between">
                    <h3 class="text-bold-700">Categories</h3>
                    <button type="button" class="btn btn-primary  mx-3 mt-2 mb-2" data-toggle="modal"
                        data-target="#modal-category">
                        <i class="bx bx-plus"></i> Category
                    </button>
                    <?php echo $__env->make('admin.category.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                </div>
                <div class="card-body">
                    <?php if(session()->has('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session()->get('success')); ?>

                        </div>
                    <?php endif; ?>
                    <!-- Table with outer spacing -->
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>NAME</th>
                                    <th>PARENT NAME</th>
                                    <th>CREATED DATE</th>
                                    <th>STATUS</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-bold-500">
                                            <a href="#" data-toggle="modal"
                                                data-target="#modal_category_edit<?php echo e($item->id); ?>">
                                                <?php echo e($item->name); ?>

                                            </a>
                                        </td>
                                        <td class="text-bold-500">
                                            <?php if($item->parent_id !== null): ?>
                                                <?php echo e($item->chlidren->name); ?>

                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->created_at); ?></td>
                                        <td><span
                                                class="badge <?php if($item->status == 'disponible'): ?> badge-light-success
                                        <?php elseif($item->status == 'finished'): ?>
                                        badge-light-danger
                                        <?php else: ?>
                                        badge-light-warning <?php endif; ?> badge-pill"><?php echo e($item->status); ?></span>
                                        </td>
                                        <td class="d-flex">
                                            <button type="button" class="btn" data-toggle="modal"
                                                data-target="#modal_category_edit<?php echo e($item->id); ?>">
                                                <i class="bx bxs-edit-alt"></i>
                                            </button>
                                            <?php echo $__env->make('admin.category.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <form action="<?php echo e(route('admin.category.delete', ['category' => $item->id])); ?>"
                                                method="post" style="margin: 7px 0px;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('delete'); ?>
                                                <button type="submit" onclick="return(confirm('do you want to delete??'))"
                                                    class="btn" style="padding: 0; padding: 0 7px;">
                                                    <i class="bx bx-trash text-danger"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Basic Tables end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('vendor-scripts'); ?>
    <script src="<?php echo e(asset('vendors/js/forms/select/select2.full.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <script src="<?php echo e(asset('js/scripts/forms/select/form-select2.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\KDS\e-commerce\resources\views/admin/category/index.blade.php ENDPATH**/ ?>