


<?php $__env->startSection('title', 'Login'); ?>



<?php $__env->startSection('page-styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/pages/authentication.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- login page start -->
    <section id="auth-login" class="row flexbox-container">

        <div class="col-xl-8 col-11">
            <div class="card bg-authentication mb-0">
                <div class="row m-0">

                    <!-- left section-login -->
                    <div class="col-md-6 col-12 px-0">
                        <div class="card disable-rounded-right mb-0 p-2 h-100 d-flex justify-content-center">
                            <?php if(session()->has('error')): ?>
                                <div class="alert alert-danger">
                                    <?php echo e(session()->get('error')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="card-header pb-1">
                                <div class="card-title">
                                    <h4 class="text-center mb-2">Welcome Back</h4>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex flex-md-row flex-column justify-content-around">
                                    <a href="#"
                                        class="btn btn-social btn-google btn-block font-small-3 mr-md-1 mb-md-0 mb-1">
                                        <i class="bx bxl-google font-medium-3"></i>
                                        <span class="pl-50 d-block text-center">Google</span>
                                    </a>
                                    <a href="#" class="btn btn-social btn-block mt-0 btn-facebook font-small-3">
                                        <i class="bx bxl-facebook-square font-medium-3"></i>
                                        <span class="pl-50 d-block text-center">Facebook</span>
                                    </a>
                                </div>
                                <div class="divider">
                                    <div class="divider-text text-uppercase text-muted">
                                        <small>or login with email</small>
                                    </div>
                                </div>
                                
                                <form method="POST" action="<?php echo e(route('admin.login.post')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group mb-50">
                                        <label class="text-bold-600" for="email">Email address</label>
                                        <input id="email" type="email"
                                            class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email"
                                            value="<?php echo e(old('email')); ?>" autocomplete="email" autofocus
                                            placeholder="Email address">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group">
                                        <label class="text-bold-600" for="password">Password</label>
                                        <input id="password" type="password"
                                            class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password"
                                            autocomplete="current-password" placeholder="Password">
                                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div
                                        class="form-group d-flex flex-md-row flex-column justify-content-between align-items-center">
                                        <div class="text-left">
                                            <div class="checkbox checkbox-sm">
                                                <input class="form-check-input" type="checkbox" name="remember"
                                                    id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="remember">
                                                    <small>Keep me logged in</small>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <a href="<?php echo e(route('password.request')); ?>" class="card-link"><small>Forgot
                                                    Password?</small></a>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary glow w-100 position-relative">Login
                                        <i id="icon-arrow" class="bx bx-right-arrow-alt"></i>
                                    </button>
                                </form>
                                <hr>
                                <div class="text-center">
                                    <small class="mr-25">Don't have an account?</small>
                                    <a href="<?php echo e(route('register')); ?>"><small>Sign up</small></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- right section image -->
                    <div class="col-md-6 d-md-block d-none text-center align-self-center p-3">
                        <img class="img-fluid" src="<?php echo e(asset('images/pages/login.png')); ?>" alt="branding logo">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- login page ends -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.fullLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\KDS\e-commerce\resources\views/admin/login/index.blade.php ENDPATH**/ ?>