<?php
    use Carbon\Carbon;
?>


<?php $__env->startSection('title', 'Users List'); ?>

<?php $__env->startSection('vendor-styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/css/tables/datatable/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/css/tables/datatable/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('vendors/css/tables/datatable/buttons.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/pages/app-users.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- users list start -->
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-12 col-sm-6 col-lg-3 d-flex align-items-center">
                        <a href="<?php echo e(route('admin.product.create')); ?>"
                            class="btn btn-info btn-block glow users-list-clear mb-0">Add Product</a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="users-list-table">
            <div class="card">
                <div class="card-body">
                    <?php if(session()->has('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session()->get('success')); ?>

                    </div>
                <?php endif; ?>
                    <!-- datatable start -->
                    <div class="table-responsive">
                        <table id="users-list-datatable" class="table">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    
                                    <th> Name</th>
                                    <th>Quantity</th>
                                    <th>Price</th>
                                    <th>status</th>
                                    <th>edit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item->id); ?></td>
                                        
                                        <td><a
                                                href="<?php echo e(route('admin.product.edit', ['product' => $item->id])); ?>"><?php echo e($item->name); ?></a>
                                        </td>
                                        <td><?php echo e($item->quantity); ?></td>
                                        <td><?php echo e($item->price); ?> BIF</td>

                                        <td><span class="badge badge-light-success">Active</span></td>
                                        <td class="d-flex">
                                            <a href="<?php echo e(route('admin.product.edit', ['product' => $item->id])); ?>"><i
                                                    class="bx bx-edit-alt"></i></a>
                                            <form action="<?php echo e(route('admin.product.delete', ['product' => $item->id])); ?>"
                                                method="post" style="margin: -4px 0px;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('delete'); ?>
                                                <button type="submit" onclick="return(confirm('do you want to delete??'))"
                                                    class="btn" style="padding: 0; padding: 0 7px;">
                                                    <i class="bx bx-trash text-danger"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- datatable ends -->
                </div>
            </div>
        </div>
    </section>
    <!-- users list ends -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('vendor-scripts'); ?>
    <script src="<?php echo e(asset('vendors/js/tables/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendors/js/tables/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendors/js/tables/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendors/js/tables/datatable/buttons.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page-scripts'); ?>
    <script src="<?php echo e(asset('js/scripts/pages/app-users.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.contentLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\KDS\e-commerce\resources\views/admin/product/index.blade.php ENDPATH**/ ?>